/*
  LZO compression tool tailored to compressing NES roms.

  This program is licensed under the GPL.

  April
    v1.0 - initial release
  May
    v1.1 - made to compile with mingw
  June 19, 2004
    v1.2 - change maximal size to 192K+16 since I'm not really
           sure that 192K+17 to 205K will actually work
  */

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include "../minilzo.107/minilzo.h"

// O_BINARY isn't needed in Linux
#ifndef O_BINARY
#define O_BINARY 0
#endif

int main(int argc, char *argv[])
{
    char *buffer, *buffer2, *workspace, *s;
    struct stat buf;
    int compressed_size, i, n;
    int in, out;

    if (argc == 3) {
	in = open(argv[1], O_RDONLY | O_BINARY);
	lzo_init();

	buffer = malloc(192 * 1024 + 16);
	buffer2 = malloc(215 * 1024);
	workspace = malloc(64 * 1024);

	fstat(in, &buf);
	compressed_size = buf.st_size;

	if (compressed_size == 0) {
	    fprintf(stderr, "Nothing to compress.\n");
	} else if (compressed_size > 192 * 1024 + 16) {
	    fprintf(stderr,
		    "File too big. File must be less than ~192K.\n");
	} else {
	    n = compressed_size;
	    s = buffer;
	    while ((i = read(in, s, n)) > 0 && i != n) {
		s += i;
		n -= i;
	    }
	    if (i == -1) {

		switch (errno) {
		case EINTR:
		    fprintf(stderr, "EINTR\n");
		    break;
		case EAGAIN:
		    fprintf(stderr, "EAGAIN\n");
		    break;
		case EIO:
		    fprintf(stderr, "EIO\n");
		    break;
		case EISDIR:
		    fprintf(stderr, "EISDIR\n");
		    break;
		case EBADF:
		    fprintf(stderr, "EBADF\n");
		    break;
		case EINVAL:
		    fprintf(stderr, "EINVAL\n");
		    break;
		case EFAULT:
		    fprintf(stderr, "EFAULT\n");
		    break;
		default:
		    fprintf(stderr, "Unknown error\n");
		    break;
		}
	    } else {
		lzo1x_1_compress(buffer, compressed_size, buffer2,
				 &compressed_size, workspace);
	        out = open(argv[2], O_TRUNC | O_WRONLY | O_CREAT | O_BINARY, 0700);
		write(out, buffer2, compressed_size);
		return 0;
	    }
	}
    } else {
	fprintf(stderr, "Usage: %s <in.nes> <out.nez>\n", argv[0]);
    }
    return 1;
}
